local old_init = UpgradesTweakData.init
function UpgradesTweakData:init(tweak_data)
	old_init(self, tweak_data)
	self.values.weapon.passive_damage_multiplier = {1, 2}
	self.values.player.chance_change_one = {}
	self.values.player.chance_change_three = {}
	self.values.player.chance_change_seven = {}
	self.values.player.chance_change_nine = {{health_restored = 1, cooldown = 5}}

	self.definitions.player_damage_multiplier_one = {
		name_id = "player_damage_multiplier_one",
		category = "feature",
		upgrade = {
			value = 2,
			upgrade = "passive_damage_multiplier",
			category = "weapon"
		}
	}
	self.definitions.pk_all_or_nothing = {
		name_id = "pk_all_or_nothing",
		category = "feature",
		upgrade = {
			value = 1,
			upgrade = "chance_change_one",
			category = "player"
		}
	}
	self.definitions.pk_gamblers_rush = {
		name_id = "pk_gamblers_rush",
		category = "feature",
		upgrade = {
			value = 1,
			upgrade = "chance_change_three",
			category = "player"
		}
	}
	self.definitions.pk_winning_streak = {
		name_id = "pk_winning_streak",
		category = "feature",
		upgrade = {
			value = 1,
			upgrade = "chance_change_seven",
			category = "player"
		}
	}
	self.definitions.pk_lifesteal = {
		name_id = "pk_lifesteal",
		category = "feature",
		upgrade = {
			value = 1,
			upgrade = "chance_change_nine",
			category = "player"
		}
	}
	
end